#include "stdafx.h"
#include "MapConstants.h"
#include "util.h"

///////////////////////////////////////////////////////////////////////
// Map Class Id's
///////////////////////////////////////////////////////////////////////
struct ClassIdString
{
    AcMap::EClassId id;
	char *str;
};

//  Class id codes

static ClassIdString IdStrings[] =
{
	// For common usage
   	
	// location boundary classes
	AcMap::kLocationBoundary, "LocationBoundary",
	AcMap::kAllBoundary, "AllBoundary",
	AcMap::kPointBoundary, "PointBoundary",
	AcMap::kCircleBoundary, "CircleBoundary",
	AcMap::kFenceBoundary, "FenceBoundary",
	AcMap::kBufferFenceBoundary, "BufferFenceBoundary",
	AcMap::kPolygonBoundary, "PolygonBoundary",
	AcMap::kWindowBoundary, "WindowBoundary",
	AcMap::kPolylineBoundary, "PolylineBoundary",
	AcMap::kBufferPolylineBoundary, "BufferPolylineBoundary",
	AcMap::kClosedPolylineBoundary, "ClosedPolylineBoundary",

	// Query Condition classes
	AcMap::kQueryUnit, "QueryUnit",
	AcMap::kQueryCondition, "QueryCondition",
	AcMap::kLocationCondition, "LocationCondition",
	AcMap::kPropertyCondition, "PropertyCondition",
	AcMap::kSQLCondition, "SQLCondition",
	AcMap::kDataCondition, "DataCondition",
	AcMap::kLocationConditionImp, "LocationConditionImp",
	AcMap::kPropertyConditionImp, "PropertyConditionImp",
	AcMap::kSQLConditionImp, "SQLConditionImp",
	AcMap::kDataConditionImp, "DataConditionImp",
	AcMap::kQueryBranch, "QueryBranch"
};

//
// getClassIdString
//
// Passes back a char pointer to the id
// associated with the code passed.
///////////////////////////////////////////////////////////////////////
char* getClassIdString(AcMap::EClassId id)
{
    int iLength = sizeof(IdStrings) / sizeof(ClassIdString);
	
	for (int i = 0; i < iLength; i++)
	{
        if (IdStrings[i].id == id)
            return IdStrings[i].str;
	}
    
	return NULL;
}


///////////////////////////////////////////////////////////////////////
// Map Property Types
///////////////////////////////////////////////////////////////////////
struct PropertyTypeString
{
    AcMap::EPropertyType type;
	char *str;
};

// object type for the property query
static PropertyTypeString PropTypeStrings[] =
{
    
	AcMap::kArea, "Area",
	AcMap::kBlockName, "BlockName",
	AcMap::kColor, "Color",
	AcMap::kElevation, "Elevation",
	AcMap::kEntType, "EntType",
	AcMap::kGroup, "Group",
	AcMap::kLayer, "Layer",
	AcMap::kLength, "Length",
	AcMap::kLineType, "LineType",
	AcMap::kTextStyle, "TextStyle",
	AcMap::kTextValue, "TextValue",
	AcMap::kThickness, "Thickness"
};

//
// getPropertyTypeString
//
// Passes back a char pointer to the type
// associated with the code passed.
///////////////////////////////////////////////////////////////////////
char* getPropertyTypeString(AcMap::EPropertyType type)
{
    int iLength = sizeof(PropTypeStrings) / sizeof(PropertyTypeString);
	
	for (int i = 0; i < iLength; i++)
	{
        if (PropTypeStrings[i].type == type)
            return PropTypeStrings[i].str;
	}
    
	return NULL;
}

///////////////////////////////////////////////////////////////////////
// Condition Types
///////////////////////////////////////////////////////////////////////
struct ConditionString
{
    AcMap::EConditionOperator condition;
	char *str;
};

// types of condition operators
static ConditionString ConditionStrings[] =
{
	AcMap::kCondEq, "CondEq",
	AcMap::kCondGT, "CondGT",
	AcMap::kCondGTorEq, "CondGTorEq",
	AcMap::kCondLT, "CondLT",
	AcMap::kCondLTorEq, "CondLTorEq",
	AcMap::kCondNotEq, "kCondNotEq",
};

//
// getPropertyConditionString
//
// Passes back a char pointer to the condition
// associated with the code passed.
///////////////////////////////////////////////////////////////////////
char* getPropertyConditionString(AcMap::EConditionOperator condition)
{
    int iLength = sizeof(ConditionStrings) / sizeof(ConditionString);
	
	for (int i = 0; i < iLength; i++)
	{
        if (ConditionStrings[i].condition == condition)
            return ConditionStrings[i].str;
	}
    
	return NULL;
}


///////////////////////////////////////////////////////////////////////
// Data Types
///////////////////////////////////////////////////////////////////////
struct DataTypeString
{
    AcMap::EDataQueryType type;
	char *str;
};

// types of condition operators
static DataTypeString DataTypeStrings[] =
{
	AcMap::kDataIRD, "DataIRD",
	AcMap::kDataAttribute, "DataAttribute",
	AcMap::kDataLinkTemplate, "DataLinkTemplate",
    AcMap::kDataEED, "DataEED"
};

//
// getDataTypeString
//
// Passes back a char pointer to the condition
// associated with the code passed.
///////////////////////////////////////////////////////////////////////
char* getDataTypeString(AcMap::EDataQueryType type)
{
    int iLength = sizeof(DataTypeStrings) / sizeof(DataTypeString);
	
	for (int i = 0; i < iLength; i++)
	{
        if (DataTypeStrings[i].type == type)
            return DataTypeStrings[i].str;
	}
    
	return NULL;
}
